<?php
include("header.php");

// $query="SELECT * from web_user";
// $users=db::getRecords($query);
// $sql = 'SELECT a.tutorial_id, a.tutorial_author, b.tutorial_count
// FROM tutorials_tbl a, tcount_tbl b
// WHERE a.tutorial_author = b.tutorial_author';


$query = "SELECT s.id, s.size, s.price, s.title, s.quantity, s.product_id, p.name FROM sizes s , product p WHERE s.product_id = p.id";
$products =db::getRecords($query);
// print_r($products);die;

?>

<section id="breadcrumb-alignment">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between breadcrumb-wrapper">
                        <nav aria-label="breadcrumb ">
                            <ol class="breadcrumb mt-2">
                                <li class="breadcrumb-item"><a href="javascript:void(0)"><i class='bx bx-home-alt mx-1'></i>Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Inventory List</a></li>
                            </ol>
                        </nav>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Breadcrumb Alignment Ends -->

<div class="card">
    <div class="card-body">
        <!-- Row grouping -->
        <section id="row-grouping-datatable">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-title">
                            <h2 class="mb-0 text-center h1 text-primary uppercase">Inventory List</h2>
                        </div>
                        <hr>
                        <div class="card-datatable">
                            <div class="table-responsive">
                                <table id="example" class="table table-bordered" style="width:100%">
                                    <thead>
                                        <tr class="text-center">
                                            <th>#</th>
                                            <!-- <th>Id</th> -->
                                            <th>Product Name</th>
                                            <th>Title</th>
                                            <th>Size</th>
                                            <th>Price</th>
                                            <th>Product Quantity</th>
                                            <th>Status</th>
                                            <!-- <th>Zip Code</th>
                                            <th>Business Name</th>
                                            <th>Location</th>
                                            <th>Status</th> -->
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php  
                                        $count=0;
                                        if($products!=null){
                                            foreach($products as $product){
                                                $count++; 
                                        ?>
                                        <tr>
                                            <td class="text-center" ><?php echo $count; ?> </td>
                                            <td class="text-center" ><?php echo  $product['name']; ?></td>
                                            <td class="text-center" ><?php echo  $product['title']; ?></td>
                                            <td class="text-center" ><?php echo  $product['size']; ?></td>
                                            <td class="text-center" ><?php echo  $product['price']; ?></td>
                                            <td class="text-center"><?php echo $product['quantity']; ?></td>
                                            <?php if( $product['quantity'] < 1 ) { ?>
                                                <td class="text-center"><div class=" badge badge-glow badge-pill badge-warning" style="font-size: 8px;">Out of stock</div></td>
                                            <?php } else { ?>
                                                <td class="text-center"><div class=" badge badge-glow badge-pill badge-success" style="font-size: 8px;">In stock</div></td>
                                            <?php } ?>
                                            
                                           
                                           
                                            <td class="text-center">
                                              
                                                <button type="button" class="btn btn-success btn-sm update-btn" data-toggle="modal" data-target="#add<?php echo $product['id']; ?>" data-count=<?php echo $product['quantity']; ?> data-id=<?php echo $product['id']; ?> style="font-size:12px;"><i class="fa fa-plus-square" aria-hidden="true"></i> Update</button>
                                                
                                            </td>
                                           
                                           
                                            <!-- <td class="text-center ">
                                                <div class="btn-group" role="group" aria-label="Basic example">
                                                    <span data-toggle="modal"  data-target="#edit_status_modal<?php echo $user['id'] ?>">
                                                        <button data-toggle="popover" data-trigger="hover" data-original-title="Edit Partner Status" type="button"  class="btn btn-linkedin text-center bg-warning bg-darken-2 mr-1 text-white  float-left" ><i class="fa fa-edit "></i></button>
                                                    </span>
                                                </div>


                                            </td> -->
                                        </tr>

                                        <!-- Modal -->
                                        <div id="add<?php echo $product['id']; ?>" class="modal fade" data-backdrop="false" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content radius-30">
                                                    <div class="modal-header bg-success border-bottom-0">
                                                        <h4 class="modal-title my-1 text-white" >Update Quantity</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body p-5">
                                                        <form action="../action.php" method="post" enctype="multipart/form-data">
                                                            <div class="form-group">
                                                                <label class="h4">Quantity</label>
                                                            </div>
                                                            <div class="form-group">
                                                            <input type="hidden" name="id" value="<?php echo $product['id']; ?>"/>
                                                            </div>
                                                            <input type="number" class="form-control" value="0" name="quantity" id="qty<?php echo $product['id']; ?>">
                                                            <hr/>
                                                            <div class="form-group">
                                                                <button type="submit" class="btn btn-success float-right  btn-lg " name="update_quantity">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                        <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--/ Row grouping -->

    </div>
</div>




<?php

include("footer.php");

?>

<Script>
    $(document).on('click', '.update-btn', function(e) {
        var quantity = $(this).data("count");
        var dataId = $(this).data("id");
        $('#' + 'qty' + dataId).val(quantity);
        console.log("#qty"+dataId);
    })
    // $('.update-btn')
</script>

