<?php
include("header.php");

$query="SELECT * from web_user";
$users=db::getRecords($query);


?>

<section id="breadcrumb-alignment">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between breadcrumb-wrapper">
                        <nav aria-label="breadcrumb ">
                            <ol class="breadcrumb mt-2">
                                <li class="breadcrumb-item"><a href="javascript:void(0)"><i class='bx bx-home-alt mx-1'></i>Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0)">Location Partners</a></li>
                            </ol>
                        </nav>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Breadcrumb Alignment Ends -->

<div class="card">
    <div class="card-body">
        <!-- Row grouping -->
        <section id="row-grouping-datatable">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-title">
                            <h2 class="mb-0 text-center h1 text-primary uppercase">Location Partners</h2>
                        </div>
                        <hr>
                        <div class="card-datatable">
                             <button class="btn btn-primary col-sm-2" style="float:right" data-toggle="modal" data-target="#add_status_modal"> Add New</button>
                            <div class="table-responsive">
                                <table id="example" class="table table-bordered" style="width:100%">
                                    <thead>
                                        <tr class="text-center">
                                            <th>#</th>
                                            <th>Partner</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Zip Code</th>
                                            <th>Business Name</th>
                                            <th>Location</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php  
                                        $count=0;
                                        if($users!=null){
                                            foreach($users as $user){
                                                $count++; 
                                        ?>
                                        <tr>
                                            <td class="text-center" ><?php echo $count; ?> </td>
                                            <td>

                                                <?php 
                                                if($user['image_name']!=null){
                                                ?>
                                                <img src="<?php echo "files/users/".$user['image_name']; ?>" style="width:100px">
                                                <?php
                                                }else{
                                                ?>
                                                <img src="files/user-removebg-preview.png" style="width:100px">
                                                <?php
                                                }
                                                ?>
                                            </td>
                                            <td class="text-center" ><?php echo  $user['name']; ?></td>
                                            <td class="text-center"><?php echo $user['email']; ?></td>
                                            <td class="text-center"><?php echo $user['phone'] ?></td>
                                            <td class="text-center"><?php echo $user['zip'] ?></td>
                                            <td class="text-center"><?php echo $user['b_name'] ?></td>
                                            <td class="text-center"><?php echo $user['address'] ?></td>


                                            <?php
                                                    $status=$user['status'];
                                                if($status==1){


                                            ?>
                                            <td class="text-center"><div class=" badge badge-glow badge-pill badge-success">Approved</div> </td>
                                            <?php
                                                }else{
                                            ?>
                                            <td class="text-center"><div class=" badge badge-glow badge-pill badge-danger">Pending</div> </td>
                                            <?php
                                                }

                                            ?>

                                            <td class="text-center ">
                                                <div class="btn-group" role="group" aria-label="Basic example">
                                                    <span data-toggle="modal"  data-target="#edit_status_modal<?php echo $user['id'] ?>">
                                                        <button data-toggle="popover" data-trigger="hover" data-original-title="Edit Partner Status" type="button"  class="btn btn-linkedin text-center bg-warning bg-darken-2 mr-1 text-white  float-left" ><i class="fa fa-edit "></i></button>
                                                    </span>
                                                    
                                                    <a href="action.php?id=<?php echo $user['id'] ?>" data-trigger="hover" data-original-title="Delete Partner" type="button" class="btn btn-linkedin text-center bg-danger bg-darken-2 text-white  float-right"><i class="fa fa-trash "></i></a>
                                                </div>


                                            </td>
                                        </tr>

                                        <!-- Modal -->
                                        <div id="edit_status_modal<?php echo $user['id'] ?>" class="modal fade" data-backdrop="false" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content radius-30">
                                                    <div class="modal-header bg-success border-bottom-0">
                                                        <h4 class="modal-title my-1 text-white" >Access Partner</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body p-5">
                                                        <form action="action.php" method="post" enctype="multipart/form-data">
                                                            <div class="form-group">
                                                                <label class="h4">Access Revoked</label>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="custom-control custom-control-success custom-switch mb-3">

                                                                    <?php
                                                $status = $user['status'];
                                                if ($status == 1) {
                                                                    ?>
                                                                    <input type="checkbox" name="status" value="1" checked class="custom-control-input" id="<?php echo $user['id']; ?>">
                                                                    <label class="h4 custom-control-label" data-label-off="NO" data-label-on="YES" for="<?php echo $user['id']; ?>">Status</label>
                                                                    <?php } else {
                                                                    ?>
                                                                    <input type="checkbox" name="status" value="1"  class="custom-control-input" id="<?php echo $user['id']; ?>">
                                                                    <label class="h4 custom-control-label" data-label-off="NO" data-label-on="YES" for="<?php echo $user['id']; ?>">Status</label>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                            <input type="text" value="<?php echo $user['id']?>" name="id" hidden>
                                                            <hr/>
                                                            <div class="form-group">
                                                                <button type="submit" class="btn btn-success float-right  btn-lg " name="edit_customer_access">Update Access</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                        <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                
                                 <!-- Add new partner Modal -->
                                <div id="add_status_modal" class="modal fade" data-backdrop="false" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content radius-30">
                                            <div class="modal-header bg-success border-bottom-0">
                                                <h4 class="modal-title my-1 text-white">Add New Partner</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body p-5">
                                                <form action="action.php" method="post" enctype="multipart/form-data">
                                                    <div>
                                                        <label style="font-weight: 600;">Location Partner Name</label>
                                                        <input type="text" name="name" class="form-control" />

                                                        <label style="font-weight: 600;">Email</label>
                                                        <input type="email" name="email" class="form-control" />

                                                        <label style="font-weight: 600;">Phone</label>
                                                        <input type="tel" name="phone" class="form-control" />

                                                        <label style="font-weight: 600;">Zip</label>
                                                        <input type="text" name="zip" class="form-control" />


                                                        <label style="font-weight: 600;">Business Name</label>
                                                        <input type="text" name="b_name" class="form-control" />


                                                        <label style="font-weight: 600;">Location</label>
                                                        <input type="text" name="address" class="form-control" />


                                                        <label style="font-weight: 600;">Upload Image</label>
                                                        <input type="file" name="file" class="form-control" />
                                                    </div>

                                                    <button type="submit" name="add_partner" class="btn btn-primary mt-5">Submit</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--/ Row grouping -->

    </div>
</div>




<?php

include("footer.php");

?>

